#!/usr/bin/env python3
"""
generate sequence of filename that does not exceed MAX_LEN=260
for Python < 3.6 and Windows without modified registry
"""

import sys
import string

name_len = 260 - len(sys.argv[2]) - 4 - 39 - 4 - 2
if name_len < 1:
    raise ValueError('The meson build directory pathname is so long '
                     'that we cannot generate filenames within 260 characters.')
# leave room for suffix and file separators, and meson generated text
# e.g. ".c.obj.d" and other decorators added by Meson at configuration
# for intermediate files

base = string.ascii_letters * 5  # 260 characters
max_num_len = len(str(sys.argv[1]))
base = base[: name_len - max_num_len]

for i in range(int(sys.argv[1])):
    print("{base}{i:0{max_num_len}d}".format(base=base, max_num_len=max_num_len, i=i))
